<?php
 
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # p0wersurge.com presents a fresh release                          # ||
|| # ---------------------------------------------------------------- # ||
|| # CometChat 4                                                      # ||
|| # ---------------------------------------------------------------- # ||
|| # Nulled by x iJB x                                                # ||
|| # This is a p0wersurge.com release                                 # ||
|| # ---------------------------- Greetz ---------------------------- # ||
|| # TeamPS extends their greetz to all the nullification scene,      # ||
|| # including FS and DGT. Thanks go to FS for teaching me to null    # ||
|| # properly. Thanks also go to decodeby.us (RIP) for the ionCube    # ||
|| # decoder I use for decoding certain scripts :p                    # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class Comet {
    private $ORIGIN        = 'x3.chatforyoursite.com';
    private $LIMIT         = 1800;
    private $PUBLISH_KEY   = '';
    private $SUBSCRIBE_KEY = '';
    private $SECRET_KEY    = false;
    private $SSL           = false;

    function Comet(
        $publish_key,
        $subscribe_key,
        $secret_key = false,
        $ssl = false
    ) {
        $this->PUBLISH_KEY   = $publish_key;
        $this->SUBSCRIBE_KEY = $subscribe_key;
        $this->SECRET_KEY    = $secret_key;
        $this->SSL           = $ssl;

        if ($ssl) $this->ORIGIN = 'https://' . $this->ORIGIN;
        else      $this->ORIGIN = 'http://'  . $this->ORIGIN;
    }

    function publish($args) {
        if (!($args['channel'] && $args['message'])) {
            echo('Missing Channel or Message');
            return false;
        }

        $channel = $args['channel'];
        $message = json_encode($args['message']);

        $string_to_sign = implode( '/', array(
            $this->PUBLISH_KEY,
            $this->SUBSCRIBE_KEY,
            $this->SECRET_KEY,
            $channel,
            $message
        ) );

        $signature = $this->SECRET_KEY ? md5($string_to_sign) : '0';

        if (strlen($message) > $this->LIMIT) {
            echo('Message TOO LONG (' . $this->LIMIT . ' LIMIT)');
            return array( 0, 'Message Too Long.' );
        }

        return $this->_request(array(
            'publish',
            $this->PUBLISH_KEY,
            $this->SUBSCRIBE_KEY,
            $signature,
            $channel,
            '0',
            $message
        ));
    }


    function history($args) {
        $limit   = +$args['limit'] ? +$args['limit'] : 10;
        $channel = $args['channel'];

        if (!$channel) {
            echo('Missing Channel');
            return false;
        }

        return $this->_request(array(
            'history',
            $this->SUBSCRIBE_KEY,
            $channel,
            '0',
            $limit
        ));
    }

    function time() {
        $response = $this->_request(array(
            'time',
            '0'
        ));

        return $response[0];
    }

    private function _request($request) {
        $request = array_map( 'Comet_encode', $request );
        array_unshift( $request, $this->ORIGIN );

        $ctx = stream_context_create(array(
            'http' => array( 'timeout' => 200 ) 
        ));

        return json_decode( file_get_contents(
            implode( '/', $request ), 0, $ctx
        ), true );
    }

}

function Comet_encode($part) {
	return implode( '', array_map(
		'Comet_encode_char', str_split($part)
	));
}

function Comet_encode_char($char) {
	if (strpos( ' ~`!@#$%^&*()+=[]\\{}|;\':",./<>?', $char ) === false)
		return $char;
	return rawurlencode($char);
}